/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import java.util.List;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.systems.LanguageSystem;

public class ItemBullet
extends AItemSubTyped<JSONBullet> {
    public static final String BULLET_QTY_KEY = "bulletQty";

    public ItemBullet(JSONBullet definition, JSONSubDefinition subDefinition, String sourcePackID) {
        super(definition, subDefinition, sourcePackID);
    }

    @Override
    public void addTooltipLines(List<String> tooltipLines, IWrapperNBT data) {
        super.addTooltipLines(tooltipLines, data);
        for (JSONBullet.BulletType type : ((JSONBullet)this.definition).bullet.types) {
            switch (type) {
                case ARMOR_PIERCING: {
                    tooltipLines.add(LanguageSystem.ITEMINFO_BULLET_TYPE_ARMOR_PIERCING.getCurrentValue());
                    break;
                }
                case EXPLOSIVE: {
                    tooltipLines.add(LanguageSystem.ITEMINFO_BULLET_TYPE_EXPLOSIVE.getCurrentValue());
                    break;
                }
                case INCENDIARY: {
                    tooltipLines.add(LanguageSystem.ITEMINFO_BULLET_TYPE_INCENDIARY.getCurrentValue());
                    break;
                }
                case WATER: {
                    tooltipLines.add(LanguageSystem.ITEMINFO_BULLET_TYPE_WATER.getCurrentValue());
                }
            }
        }
        if (((JSONBullet)this.definition).bullet.pellets > 0) {
            tooltipLines.add(LanguageSystem.ITEMINFO_BULLET_PELLETS.getCurrentValue() + ((JSONBullet)this.definition).bullet.pellets);
        }
        tooltipLines.add(LanguageSystem.ITEMINFO_BULLET_DIAMETER.getCurrentValue() + ((JSONBullet)this.definition).bullet.diameter);
        tooltipLines.add(LanguageSystem.ITEMINFO_BULLET_CASELENGTH.getCurrentValue() + ((JSONBullet)this.definition).bullet.caseLength);
        tooltipLines.add(LanguageSystem.ITEMINFO_BULLET_PENETRATION.getCurrentValue() + ((JSONBullet)this.definition).bullet.armorPenetration);
        tooltipLines.add(LanguageSystem.ITEMINFO_BULLET_QUANTITY.getCurrentValue() + (data.hasKey(BULLET_QTY_KEY) ? data.getInteger(BULLET_QTY_KEY) : ((JSONBullet)this.definition).bullet.quantity));
    }
}

